/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.app.FileTypeGroup;
import DE.siemens.ad.logo.util.Global;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;

public class FileType
extends FileFilter
implements Storable {
    protected Icon fIcon;
    protected String fName;
    protected String fExtension;
    private static Hashtable fFileTypes = new Hashtable(30);
    protected boolean fVisibleInFileChooser = true;
    protected String fIconName;

    protected FileType() {
    }

    protected FileType(String extension, String name, Icon icon) {
        this.fName = name;
        this.fIcon = icon;
        this.fExtension = extension;
    }

    protected FileType(String extension, String name, Icon icon, boolean visibleInFileChooser) {
        this(extension, name, icon);
        this.setVisibleInFileChooser(visibleInFileChooser);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(this.getExtension().toLowerCase());
    }

    public static Collection getAvailableFileTypes() {
        return fFileTypes.values();
    }

    public String getDescription() {
        return this.fName + " (" + this.getExtensionLong() + ")";
    }

    public String getExtension() {
        return this.fExtension;
    }

    public String getExtensionLong() {
        return "*." + this.fExtension;
    }

    public static FileType getFileType(String extension, String name, Icon icon) {
        if (!fFileTypes.containsKey(extension)) {
            fFileTypes.put(extension, new FileType(extension, name, icon));
        }
        return (FileType)fFileTypes.get(extension);
    }

    public static FileType getFileType(String extension, String name, Icon icon, boolean visibleInFileChooser) {
        if (!fFileTypes.containsKey(extension)) {
            fFileTypes.put(extension, new FileType(extension, name, icon, visibleInFileChooser));
        }
        return (FileType)fFileTypes.get(extension);
    }

    public static FileTypeGroup getFileTypeGroup(String key, String name) {
        if (!fFileTypes.containsKey(key)) {
            fFileTypes.put(key, new FileTypeGroup(name));
        }
        return (FileTypeGroup)fFileTypes.get(key);
    }

    public static FileTypeGroup getFileTypeGroup(String key, String name, Vector fileTypes) {
        FileTypeGroup group = FileType.getFileTypeGroup(key, name);
        Enumeration e = fileTypes.elements();
        while (e.hasMoreElements()) {
            group.addFileType((FileType)e.nextElement());
        }
        return group;
    }

    public Icon getIcon() {
        if (this.fIcon == null) {
            this.fIcon = Global.getIcon(this.fIconName);
        }
        return this.fIcon;
    }

    public String getIconName() {
        return this.fIconName;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isVisibleInFileChooser() {
        return this.fVisibleInFileChooser;
    }

    public void read(StorableInput si) throws IOException {
        this.fName = si.readString();
        this.fExtension = si.readString();
        this.fIconName = si.readString();
        this.fVisibleInFileChooser = si.readBoolean();
    }

    public void setExtension(String newExtension) {
        if (newExtension.startsWith("*.")) {
            newExtension = newExtension.substring(2);
        }
        if (newExtension.startsWith(".")) {
            newExtension = newExtension.substring(1);
        }
        this.fExtension = newExtension;
    }

    public void setIcon(Icon newIcon) {
        this.fIcon = newIcon;
    }

    public void setIconName(String newIconName) {
        this.fIconName = newIconName;
    }

    public void setName(String newName) {
        this.fName = newName;
    }

    public void setVisibleInFileChooser(boolean newVisibleInFileChooser) {
        this.fVisibleInFileChooser = newVisibleInFileChooser;
    }

    public void write(StorableOutput so) {
        so.writeString(this.fName);
        so.writeString(this.fExtension);
        so.writeString(this.fIconName);
        so.writeBoolean(this.fVisibleInFileChooser);
    }

    public String toString() {
        return this.getName() + "(" + this.getExtension() + ";" + super.toString() + ")";
    }
}

